function [iy, id, ih, im, ss] =  ep2dat(time)
% Converts epochal time to yr,day,hr,mn,sec
% epochal time is defined by CSS to
% be the time in secs from 1970 day 0.
% 
% input:
%  time
% output:
%  iy = year
%  id = day of year (often called Julian day)
%  ih = hour of day
%  im = minutes
%  ss = seconds
%
      if time < 0.0
        error('ERROR in ep2dat -- epochal time < 0');
      end;
      kd  = fix(time / 86400.);
      sec = time - (86400. * kd);
      ky  = 1970;
      idpy = 365;
      
      while kd >= idpy
          ky = ky + 1;
          kd = kd - idpy;
          idpy = 365;
          if mod(ky,4) == 0
              idpy=366;
          end;
      end;
      iy = ky;
      id = kd + 1;
      ih = fix(sec / 3600.d0);
      im = fix( (sec - (3600.d0 * ih)) / 60.d0 );
      ss = sec - 3600.d0*ih - 60.d0*im;